"""
HB_Phongselection V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_Phongselection
Description-US: Activates Polygon-mode and Phongbreakselection Tool

Activates Polygon-mode and sets up the Phongbreakselection tool.

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=1m18s

Name-DE: HB_Phongselection
Description-DE: Aktiviert Polygon Modus und Phongbreak Selektion 

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon

"""

import c4d
from c4d import documents, plugins
  
def tool():
    return c4d.plugins.GetToolData(doc, doc.GetAction())

def main():

    c4d.CallCommand(12187) # Polygons
    c4d.CallCommand(1019730) # Phong Break Selection
    
    tool()[c4d.MDATA_PWS_OVERRIDE_PHONG]=True
    tool()[c4d.MDATA_PWS_ANGLE_THRESHOLD]=c4d.utils.Rad(15)
    tool()[c4d.MDATA_PWS_USE_PHONGBREAKS]=False


if __name__=='__main__':
    main()
    c4d.EventAdd()